/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.IVWSIMScenario;
import filenet.sim.api.VWScenarioDefinition;
import filenet.vw.api.VWException;
import filenet.vw.idm.toolkit.IVWIDMDocument;
import java.io.ByteArrayInputStream;
import java.util.GregorianCalendar;

public class VWSIMScenario
implements IVWSIMScenario {
    private IVWIDMDocument m_idmDocument = null;
    private VWScenarioDefinition m_scenarioDefinition = null;

    public VWSIMScenario(IVWIDMDocument idmDocument) {
        this.m_idmDocument = idmDocument;
    }

    public String getName() throws VWException {
        return this.m_idmDocument.getLabel();
    }

    public String getDescription() throws VWException {
        return (String)this.m_idmDocument.getProp("ScenarioDescription");
    }

    public boolean getCollectAnalysisData() throws VWException {
        Boolean b = (Boolean)this.m_idmDocument.getProp("PublishingEnabled");
        if (b != null) {
            return b;
        }
        return false;
    }

    public String getDocId() {
        return this.m_idmDocument.getId();
    }

    public String getLibraryId() {
        return this.m_idmDocument.getLibraryId();
    }

    public VWScenarioDefinition getScenarioDefinition() throws VWException {
        VWScenarioDefinition sceDef = null;
        if (this.m_scenarioDefinition != null) {
            sceDef = this.m_scenarioDefinition;
            return sceDef;
        }
        byte[] contents = null;
        contents = this.m_idmDocument.getContents();
        ByteArrayInputStream is = null;
        if (contents != null) {
            is = new ByteArrayInputStream(contents);
        }
        this.m_scenarioDefinition = sceDef = VWScenarioDefinition.read(is);
        return sceDef;
    }

    public void deleteScenario() throws VWException {
        this.m_idmDocument.delete();
    }

    public String getLastModifier() throws VWException {
        return (String)this.m_idmDocument.getProp("LastModifier");
    }

    public GregorianCalendar getDateLastModified() throws VWException {
        return (GregorianCalendar)this.m_idmDocument.getProp("DateLastModified");
    }

    public IVWIDMDocument getIDMDocument() {
        return this.m_idmDocument;
    }

    public void refresh() throws VWException {
        this.m_idmDocument.refresh();
    }
}

